/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Getopt;
import Vdb.CsimEntry;
import Vdb.CsimExtent;
import Vdb.common;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.zip.GZIPOutputStream;

public class csim {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static RandomAccessFile raf;
    private static int xfersize;
    private static double pct;
    private static int level;
    private static double raw_used;
    private static double subset;
    private static long volsize;
    private static long volblocks;
    private static boolean raw_volume;
    private static int need_header;
    private static int total_file_count;
    private static long total_file_size;
    private static int blocks_read;
    private static long bytes_read;
    private static long bytes_out;
    private static int file_line_length;
    private static int null_files;
    private static ArrayList<CsimEntry> file_list;
    private static String level_splitter;
    private static Random randomizer;
    private static int max_fname_length;
    private static double KB;
    private static double MB;
    private static double GB;
    private static double TB;
    private static double PB;

    public static void main(String[] stringArray) {
        Getopt getopt = new Getopt(stringArray, "l:p:u:d:r:s:", 10000);
        if (!getopt.isOK() || getopt.get_positionals().size() == 0) {
            common.ptod("Usage: ./vdbench csim [-l nnn] [-p nnn] [-x nnn] [-s nnn] disk1, disk2, file1, file2, .....");
            common.ptod("Where: ");
            common.ptod("     -l nnn: gzip compression level to use, default 1");
            common.ptod("     -p nnn: which percentage of data to read, default 0.1%");
            common.ptod("     -s nnn: subset percentage. e.g. -s10 reports compression for each 10% of the volume");
            common.ptod("     -u nnn: transfer size unit in bytes for blocks to be read and compressed. Default 128k");
            common.ptod("     disk1, file1, ...: up to 10000 disk or file names or windows drive letters (c)");
            common.failure("parameter error");
        }
        if (getopt.check('p')) {
            pct = getopt.get_double();
        }
        if (getopt.check('l')) {
            level = (int)getopt.get_long();
        }
        if (getopt.check('s')) {
            subset = getopt.get_double();
        }
        if (getopt.check('u')) {
            xfersize = getopt.extractInt();
        }
        file_line_length = 29;
        csim.createFileList(getopt);
        common.ptod("");
        csim.doFiles();
        System.exit(0);
    }

    private static void doFiles() {
        for (int i = 0; i < file_list.size(); ++i) {
            CsimEntry csimEntry = file_list.get(i);
            for (int j = 0; j < csimEntry.extents.size(); ++j) {
                CsimExtent csimExtent = csimEntry.extents.get(j);
                long l = csimExtent.size / (long)xfersize;
                long l2 = pct >= 99.0 ? l : (long)((int)((double)l * pct / 100.0) + 1);
                Long[] longArray = csim.createSampleList(l, l2);
                csim.readExtent(longArray, csimEntry, csimExtent);
                if (csimEntry.extents.size() <= 1) continue;
                if (csimExtent.extno == 1) {
                    common.ptod("");
                }
                csim.printit(String.format("%s (%d)", csimEntry.fname, csimExtent.extno), csimExtent);
            }
            csim.printit(String.format("%s", csimEntry.fname), csimEntry.main_extent);
        }
    }

    private static void printit(String string, CsimExtent csimExtent) {
        double d = (double)csimExtent.bytes_out * 100.0 / (double)csimExtent.bytes_in;
        double d2 = (double)csimExtent.bytes_in / (double)csimExtent.bytes_out;
        String string2 = "%-" + max_fname_length + "s";
        common.ptod(string2 + " size: %6s samples: %5d in: %6s out: %6s pct: %5.1f compratio: %7.2f:1", string, csim.whatSize(csimExtent.size), csimExtent.blocks_read, csim.whatSize(csimExtent.bytes_in), csim.whatSize(csimExtent.bytes_out), d, d2);
    }

    private static Long[] createSampleList(long l, long l2) {
        randomizer = new Random(0L);
        int n = 0;
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>((int)l2 * 2);
        int n2 = 0;
        while ((long)n2 < l2) {
            long l3 = (long)(randomizer.nextDouble() * (double)l) * (long)xfersize;
            if (hashMap.get(l3) != null) {
                ++n;
                --n2;
            } else {
                hashMap.put(l3, l3);
            }
            ++n2;
        }
        Object[] objectArray = hashMap.keySet().toArray(new Long[0]);
        Arrays.sort(objectArray);
        hashMap = null;
        return objectArray;
    }

    private static long determineVolSize(String string) {
        byte[] byArray = new byte[512];
        long l = 0L;
        long l2 = 0x4000000000000L;
        if (!string.startsWith("\\\\") && new File(string).isDirectory()) {
            common.ptod("File name skipped; is a directory: " + string);
            return -1L;
        }
        raw_volume = true;
        if (new File(string).length() != 0L) {
            raw_volume = false;
            return new File(string).length();
        }
        if (!string.startsWith("\\\\") && !string.startsWith("/dev")) {
            ++null_files;
            return -1L;
        }
        try {
            raf = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            common.ptod("Exception opening file/lun " + string);
            common.failure(exception);
        }
        int n = 0;
        do {
            long l3 = l + (l2 - l) / 2L & 0xFFFFFFFFFFFFFE00L;
            ++n;
            if (csim.tryRead(byArray, l3)) {
                l = l3;
                continue;
            }
            l2 = l3;
        } while (l + 512L != l2);
        try {
            raf.close();
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        return (long)((double)(l + 512L) * raw_used / 100.0);
    }

    private static boolean tryRead(byte[] byArray, long l) {
        try {
            raf.seek(l);
            int n = raf.read(byArray);
            return n > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void createFileList(Getopt getopt) {
        long l = System.currentTimeMillis();
        try {
            for (int i = 0; i < getopt.get_positionals().size(); ++i) {
                String string = getopt.get_positional(i);
                if (common.onWindows() && string.length() == 2 && string.endsWith(":")) {
                    common.ptod("\n\n");
                    common.ptod("Asking for file, directory or volume '%s'", string);
                    common.failure("Windows: specify either single drive letter 'c' or directory 'c:\\'. ");
                }
                File file = new File(string);
                if (!common.onWindows() && string.startsWith("/dev/")) {
                    csim.addFile(string);
                    continue;
                }
                if (file.isFile()) {
                    csim.addFile(file.getAbsolutePath());
                    continue;
                }
                if (file.isDirectory()) {
                    common.ptod("Ignoring directory: " + file.getAbsolutePath());
                    continue;
                }
                if (common.onWindows() && string.length() == 1) {
                    String string2 = string;
                    string = String.format("\\\\.\\%s:", string);
                    csim.addFile(string);
                    continue;
                }
                common.ptod("Unknown file type? " + string);
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    private static void addFile(String string) {
        CsimEntry csimEntry = new CsimEntry();
        csimEntry.fname = string;
        long l = csim.determineVolSize(string);
        if (l <= 0L) {
            return;
        }
        max_fname_length = Math.max(max_fname_length, string.length());
        csimEntry.main_extent = new CsimExtent(0L, l, 0);
        csimEntry.extents.add(csimEntry.main_extent);
        if (subset != 100.0) {
            int n = 100 / (int)subset;
            long l2 = l / (long)n;
            csimEntry.extents.clear();
            for (int i = 0; i < n; ++i) {
                long l3 = (long)i * l2;
                l3 -= l3 % (long)xfersize;
                csimEntry.extents.add(new CsimExtent(l3, l2, i + 1));
            }
        }
        csimEntry.size = l;
        file_list.add(csimEntry);
        total_file_size += l;
        ++total_file_count;
        if (file_line_length > 80) {
            common.ptod("");
            file_line_length = 0;
        }
        if (total_file_count % 10000 == 0) {
            String string2 = String.format("%7d ", total_file_count);
            file_line_length += string2.length();
            System.out.print(string2);
        }
    }

    private static void readExtent(Long[] longArray, CsimEntry csimEntry, CsimExtent csimExtent) {
        byte[] byArray = new byte[xfersize];
        long l = 0L;
        try {
            raf = new RandomAccessFile(csimEntry.fname, "r");
            for (int i = 0; i < longArray.length; ++i) {
                l = longArray[i] + csimExtent.start_lba;
                raf.seek(l);
                int n = raf.read(byArray, 0, xfersize);
                if (n < 0) {
                    common.ptod("ce: " + csimEntry);
                    common.failure("problem reading file");
                }
                long l2 = csim.compressBuffer(byArray);
                csimExtent.bytes_in += (long)n;
                csimExtent.bytes_out += l2;
                ++csimExtent.blocks_read;
                if (csimEntry.extents.size() <= 1) continue;
                csimEntry.main_extent.bytes_in += (long)n;
                csimEntry.main_extent.bytes_out += l2;
                ++csimEntry.main_extent.blocks_read;
            }
            raf.close();
        }
        catch (IOException iOException) {
            common.ptod("IOException: " + iOException.getMessage());
            common.ptod("extent.start_lba: " + csimExtent.start_lba);
            common.ptod("lba:            %12d %16x  ", l, l);
        }
        catch (Exception exception) {
            common.ptod("");
            common.failure(exception);
        }
    }

    private static int compressBuffer(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(xfersize);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)dataOutputStream, xfersize){
                {
                    this.def.setLevel(level);
                }
            };
            gZIPOutputStream.write(byArray, 0, xfersize);
            gZIPOutputStream.close();
            int n = byteArrayOutputStream.size();
            return n;
        }
        catch (Exception exception) {
            common.ptod(exception);
            return 0;
        }
    }

    public static String whatSize(double d) {
        if (d < KB) {
            return "" + d;
        }
        String string = d < MB ? String.format("%.1fk", d / KB) : (d < GB ? String.format("%.1fm", d / MB) : (d < TB ? String.format("%.1fg", d / GB) : (d < PB ? String.format("%.1ft", d / TB) : String.format("%.1fp", d / PB))));
        String string2 = string.substring(0, string.length() - 3);
        String string3 = string.substring(string.length() - 3);
        if (string3.startsWith(".0")) {
            string = string2 + string3.substring(2);
        }
        return string;
    }

    static {
        xfersize = 131072;
        pct = 0.1;
        level = 1;
        raw_used = 100.0;
        subset = 100.0;
        raw_volume = false;
        need_header = 0;
        total_file_count = 0;
        total_file_size = 0L;
        blocks_read = 0;
        bytes_read = 0L;
        bytes_out = 0L;
        file_line_length = 0;
        null_files = 0;
        file_list = new ArrayList(1024);
        level_splitter = common.onWindows() ? "\\+" : "/+";
        randomizer = new Random(0L);
        max_fname_length = 0;
        KB = 1024.0;
        MB = 1048576.0;
        GB = 1.073741824E9;
        TB = 1.099511627776E12;
        PB = 1.125899906842624E15;
    }
}

