/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Getopt;
import Utils.OS_cmd;
import Vdb.DsimFile;
import Vdb.FileAnchor;
import Vdb.Signal;
import Vdb.common;
import java.io.File;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class dsim {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    protected static int dedupunit = 131072;
    private static int total_file_count = 0;
    private static long total_file_size = 0L;
    public static long total_blocks = 0L;
    protected static long sample_start;
    protected static int files_read;
    protected static int blocks_read;
    protected static int blocks_hashed;
    protected static long bytes_read;
    protected static long bytes_hashed;
    private static int file_line_length;
    private static int null_files;
    protected static Signal signal;
    protected static long last_mb_reported;
    private static ArrayList<DsimFile> file_list;
    private static long cum_filesize;
    protected static HashMap<String, MessageDigest> dedup_map;
    protected static HashMap<String, Long> count_map;
    protected static HashMap<Long, Long> set_map;
    private static boolean quiet;
    protected static int max_workers;
    protected static int max_files;
    protected static long start_lba;
    protected static long end_lba;
    protected static Vector<DsimFile> active_files;
    protected static int xfersize;
    private static int last_level;

    public static void main(String[] stringArray) throws NoSuchAlgorithmException {
        Getopt getopt = new Getopt(stringArray, "qn:u:d:w:f:x:s:e:", 10000);
        quiet = getopt.check('q');
        if (!getopt.isOK() || getopt.get_positionals().size() == 0) {
            common.ptod("Usage: ./vdbench dsim [-n sss] [-w nn] [-f nn] [-u nnnk] disk1, disk2, dir1, dir2, file1, file2, .....");
            common.ptod("Where: ");
            common.ptod("     -u nnn: dedup unit, amount of bytes to be used for deduplication");
            common.ptod("     -n sss: Notify about progress every 'sss' seconds, default 60.");
            common.ptod("     -w nnn: How many 'worker threads' hashing a block. Default 4");
            common.ptod("     -f nnn: How many 'lun/file threads' reading luns and files. Default 2");
            common.ptod("     disk1, file1, ...: up to 10000 disk or file names or windows drive letters (c)");
            common.failure("parameter error");
        }
        if (getopt.check('n')) {
            signal = new Signal((int)getopt.get_long());
        }
        if (getopt.check('w')) {
            max_workers = (int)getopt.get_long();
        }
        if (getopt.check('f')) {
            max_files = (int)getopt.get_long();
        }
        if (getopt.check('s')) {
            start_lba = getopt.extractLong();
        }
        if (getopt.check('e')) {
            end_lba = getopt.extractLong();
        }
        if (!getopt.check('u')) {
            common.failure("'-u nnn' parameter is required to know what the dedup unit size is");
        }
        if ((dedupunit = getopt.extractInt()) % 512 != 0) {
            common.failure("up unit '%d' not divisible by 512 (did you forget 'k'?)", dedupunit);
        }
        xfersize = 0x100000 / dedupunit * dedupunit;
        if (getopt.check('x')) {
            xfersize = getopt.get_int();
        }
        if (!quiet) {
            System.out.print("Searching for file names ... ");
        }
        file_line_length = 29;
        dsim.createFileList(getopt);
        System.out.println();
        total_blocks = total_file_size / (long)dedupunit;
        if (!quiet) {
            common.ptod("Total file count:       %,14d", total_file_count);
            common.ptod("Total file size:        %14s", FileAnchor.whatSize(total_file_size));
            common.ptod("Total block count:      %,14d", total_blocks);
            common.ptod("Amount of data to read: %14s", FileAnchor.whatSize(total_blocks * (long)dedupunit));
            common.ptod("Worker threads:         %14d", max_workers);
            common.ptod("Concurrent files:       %14d", max_files);
            common.ptod("Dedup unit:             %14d", dedupunit);
            common.ptod("");
        }
        if (total_file_count == 0) {
            common.failure("No files found");
        }
        sample_start = System.currentTimeMillis();
        dsim.readFiles();
        String[] stringArray2 = count_map.keySet().toArray(new String[0]);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (String string : stringArray2) {
            long l4 = count_map.get(string);
            if (l4 > 1L) {
                ++l3;
                l += l4;
            }
            l2 = Math.max(l2, l4);
        }
        long l5 = (long)blocks_hashed - l;
        if (!quiet) {
            common.ptod("Reads done:       %,14d (of xfersize %d)", blocks_read, xfersize);
            common.ptod("Blocks_hashed:    %,14d (of dedupunit %d)", blocks_hashed, dedupunit);
            common.ptod("Hash size:        %,14d", dedup_map.size());
            common.ptod("Dedup sets:       %,14d", l3);
            common.ptod("Duplicate blocks: %,14d", l);
            common.ptod("Unique blocks:    %,14d", l5);
            common.ptod("");
        }
        dsim.reportStats();
        common.ptod("Please realize that there is no absolute guarantee, especially with smaller");
        common.ptod("configurations, that each of the requested dedup sets is referenced.");
        if (!quiet && l > 0L) {
            common.ptod("Average duplicate count per duplicate hash: %,8d", l / l);
            common.ptod("Maximum collisions:                         %,8d", l2);
        }
        Object[] objectArray = set_map.keySet().toArray(new Long[0]);
        Arrays.sort(objectArray);
        long l6 = 0L;
        for (Object object : objectArray) {
            l6 += set_map.get(object).longValue();
        }
        common.ptod("Number of sets found: %,d counting %,d duplicates", set_map.size(), l6);
    }

    private static long determineVolSize(String string) {
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = new byte[512];
        long l = 0L;
        long l2 = 0x640000000000L;
        if (!string.startsWith("\\\\") && new File(string).isDirectory()) {
            common.ptod("File name skipped; is a directory: " + string);
            return -1L;
        }
        if (new File(string).length() != 0L) {
            return new File(string).length();
        }
        if (!string.startsWith("\\\\") && !string.startsWith("/dev")) {
            ++null_files;
            return -1L;
        }
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (Exception exception) {
            common.ptod("Exception opening file/lun " + string);
            common.failure(exception);
        }
        int n = 0;
        do {
            long l3 = l + (l2 - l) / 2L & 0xFFFFFFFFFFFFFE00L;
            ++n;
            if (dsim.tryRead(randomAccessFile, byArray, l3)) {
                l = l3;
                continue;
            }
            l2 = l3;
        } while (l + 512L != l2);
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        return l + 512L;
    }

    private static boolean tryRead(RandomAccessFile randomAccessFile, byte[] byArray, long l) {
        try {
            randomAccessFile.seek(l);
            int n = randomAccessFile.read(byArray);
            return n > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static synchronized void countReads(int n) {
        bytes_read += (long)n;
        ++blocks_read;
    }

    public static synchronized void countFiles() {
        ++files_read;
    }

    private static void createFileList(Getopt getopt) {
        long l = System.currentTimeMillis();
        try {
            for (int i = 0; i < getopt.get_positionals().size(); ++i) {
                String string = getopt.get_positional(i);
                if (common.onWindows() && string.length() == 2 && string.endsWith(":")) {
                    common.ptod("\n\n");
                    common.ptod("Asking for file, directory or volume '%s'", string);
                    common.failure("Windows: specify either single drive letter 'c' or directory 'c:\\'. ");
                }
                File file = new File(string);
                if (!common.onWindows() && string.startsWith("/dev/")) {
                    dsim.addFile(string);
                    continue;
                }
                if (file.isFile()) {
                    dsim.addFile(file.getAbsolutePath());
                    continue;
                }
                if (file.isDirectory()) {
                    dsim.scanDirectory(file);
                    continue;
                }
                if (common.onWindows() && string.length() == 1) {
                    String string2 = string;
                    string = String.format("\\\\.\\%s:", string);
                    dsim.addFile(string);
                    common.ptod("\nChanging '%s' to windows raw device %s", string2, string);
                    continue;
                }
                common.ptod("Unknown file type? " + string);
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        double d = System.currentTimeMillis() - l;
        if (!quiet) {
            System.out.println();
            common.ptod("createFileList took %.1f seconds", d / 1000.0);
        }
    }

    private static void scanDirectory(File file) {
        try {
            String string = file.getAbsolutePath();
            if (dsim.isThisLink(string)) {
                common.ptod("Directory appears to be a link. Ignored: " + string);
                return;
            }
            String[] stringArray = file.list();
            if (stringArray == null) {
                common.ptod("\nscanDirectory: " + file.getAbsolutePath());
                common.ptod("You may not have the proper priviliges to read this directory. Directory is bypassed");
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.equals("no_dismount.txt") || string2.equals("vdb_control.file")) continue;
                File file2 = new File(string, string2);
                if (file2.isFile()) {
                    dsim.addFile(file2.getAbsolutePath());
                    continue;
                }
                dsim.scanDirectory(file2);
            }
        }
        catch (Exception exception) {
            common.ptod("\nscanDirectory: " + file.getAbsolutePath());
            common.ptod("This directory is bypassed");
            common.ptod(exception);
        }
    }

    public static void reportStats() {
        long l = blocks_hashed - dedup_map.size();
        double d = System.currentTimeMillis() - sample_start;
        double d2 = d > 0.0 ? (double)bytes_read / (d / 1000.0) / 1000000.0 : 0.0;
        double d3 = blocks_hashed == 0 ? 0.0 : (double)blocks_hashed / (double)dedup_map.size();
        common.ptod("Totals: Dedup ratio: %.2f:1 (%.5f) Files read: %,6d; Reads done: %,12d; mb/sec: %6.2f", d3, d3, files_read, blocks_read, d2);
    }

    private static boolean isThisLink(String string) {
        if (common.onWindows()) {
            return false;
        }
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText("/usr/bin/ls -ld");
        oS_cmd.addQuot(string);
        oS_cmd.execute(false);
        if (!oS_cmd.getRC()) {
            common.ptod("isThisLink: Unexpected results from %s", oS_cmd.getCmd());
            String[] stringArray = oS_cmd.getStderr();
            for (int i = 0; i < stringArray.length; ++i) {
                common.ptod("stderr: " + stringArray[i]);
            }
            return true;
        }
        String[] stringArray = oS_cmd.getStdout();
        if (stringArray.length != 1) {
            common.ptod("isThisLink: Unexpected results from %s", oS_cmd.getCmd());
            for (int i = 0; i < stringArray.length; ++i) {
                common.ptod("stdout: " + stringArray[i]);
            }
            return true;
        }
        return stringArray[0].startsWith("l");
    }

    private static void addFile(String string) {
        DsimFile dsimFile = new DsimFile();
        dsimFile.fname = string;
        long l = dsim.determineVolSize(string);
        if (l <= 0L) {
            return;
        }
        dsimFile.true_size = l;
        dsimFile.rel_start_lba = cum_filesize;
        cum_filesize += l;
        file_list.add(dsimFile);
        total_file_size += l;
        ++total_file_count;
        if (file_line_length > 80) {
            common.ptod("");
            file_line_length = 0;
        }
        if (total_file_count % 10000 == 0) {
            String string2 = String.format("%7d ", total_file_count);
            file_line_length += string2.length();
            System.out.print(string2);
        }
    }

    private static void readFiles() {
        long l = System.currentTimeMillis();
        for (DsimFile dsimFile : file_list) {
            while (active_files.size() >= max_files) {
                common.sleep_some(1L);
            }
            active_files.add(dsimFile);
            dsimFile.start();
        }
        while (active_files.size() > 0) {
            common.sleep_some(500L);
        }
    }

    static {
        files_read = 0;
        blocks_read = 0;
        blocks_hashed = 0;
        bytes_read = 0L;
        bytes_hashed = 0L;
        file_line_length = 0;
        null_files = 0;
        signal = new Signal(60);
        last_mb_reported = 0L;
        file_list = new ArrayList(1024);
        cum_filesize = 0L;
        dedup_map = new HashMap(16384);
        count_map = new HashMap(16384);
        set_map = new HashMap(16384);
        quiet = false;
        max_workers = 4;
        max_files = 2;
        start_lba = 0L;
        end_lba = Long.MAX_VALUE;
        active_files = new Vector(6);
        xfersize = 0;
        last_level = 0;
    }
}

