/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import VdbComp.CompFrame;
import VdbComp.Delta;
import VdbComp.WlComp;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ChangeRanges
extends JDialog
implements ActionListener,
MouseListener {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private JButton ok_button = new JButton("OK");
    private JButton cancel = new JButton("Cancel");
    private JButton dflt = new JButton("Default");
    private int current_delta;
    private Delta[] deltas = Delta.getDeltas();
    private JTextField[] txt_fields = new JTextField[this.deltas.length];
    private JTextField[] color_fields = new JTextField[this.deltas.length];
    private WlComp wlcomp = null;

    public ChangeRanges(WlComp wlComp) {
        this.setModal(true);
        this.setTitle("Vdbench Compare: change colors or ranges");
        this.wlcomp = wlComp;
        this.getContentPane().setLayout(new GridLayout(this.deltas.length + 3, 2));
        for (int i = 0; i < this.deltas.length; ++i) {
            JTextField jTextField;
            Delta delta = this.deltas[i];
            this.txt_fields[i] = new JTextField();
            this.txt_fields[i].setHorizontalAlignment(4);
            this.txt_fields[i].setText("" + delta.limit);
            this.color_fields[i] = jTextField = new JTextField();
            jTextField.setBackground(delta.color);
            jTextField.setHorizontalAlignment(0);
            jTextField.setEditable(true);
            jTextField.addMouseListener(this);
            this.getContentPane().add(jTextField);
            this.getContentPane().add(this.txt_fields[i]);
            if (delta.limit != 0.0) continue;
            this.txt_fields[i].setEnabled(false);
        }
        this.getContentPane().add(this.ok_button);
        this.getContentPane().add(this.dflt);
        this.getContentPane().add(new JLabel("Click on color or range to change"));
        this.ok_button.addActionListener(this);
        this.cancel.addActionListener(this);
        this.dflt.addActionListener(this);
    }

    public static void main(String[] stringArray) {
        ChangeRanges changeRanges = new ChangeRanges(null);
        changeRanges.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        changeRanges.setLocation(120, 120);
        changeRanges.setSize(300, 300);
        changeRanges.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.ok_button.getText())) {
            for (int i = 1; i < this.txt_fields.length; ++i) {
                if (!(Double.parseDouble(this.txt_fields[i].getText()) >= Double.parseDouble(this.txt_fields[i - 1].getText()))) continue;
                JOptionPane.showMessageDialog(this, "All percentages entered must decrement in value", "Try again", 0);
                return;
            }
            double[] dArray = new double[this.txt_fields.length];
            Delta[] deltaArray = Delta.getDeltas();
            for (int i = 0; i < this.txt_fields.length; ++i) {
                dArray[i] = Double.parseDouble(this.txt_fields[i].getText());
            }
            Delta.setDeltas(dArray);
            if (CompFrame.avg_scroll != null) {
                this.wlcomp.doCompare();
            }
            this.dispose();
        } else if (string.equals(this.cancel.getText())) {
            this.dispose();
        } else if (string.equals(this.dflt.getText())) {
            Delta.setDefaults();
            for (int i = 0; i < this.color_fields.length; ++i) {
                this.color_fields[i].setBackground(this.deltas[i].color);
                this.txt_fields[i].setText("" + this.deltas[i].limit);
                this.deltas[i].setBackground(this.deltas[i].color);
            }
            Delta.createLabels();
            this.repaint();
            if (CompFrame.avg_scroll != null) {
                CompFrame.avg_scroll.repaint();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Color color = this.getBackground();
        Color color2 = JColorChooser.showDialog(null, "xxx", color);
        if (color2 == null) {
            return;
        }
        for (int i = 0; i < this.color_fields.length; ++i) {
            if (this.color_fields[i] != mouseEvent.getComponent()) continue;
            this.color_fields[i].setBackground(color2);
            this.deltas[i].setBackground(color2);
            this.deltas[i].color = color2;
            this.color_fields[i].repaint();
        }
        this.repaint();
    }
}

