/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Utils.Fget;
import Utils.OS_cmd;
import Vdb.common;
import VdbComp.CompException;
import VdbComp.CompRunData;
import VdbComp.DataModel;
import VdbComp.DataModel2;
import VdbComp.DataPair;
import VdbComp.Delta;
import VdbComp.DeltaValue;
import VdbComp.MultiLineHeader;
import VdbComp.Pop_list;
import VdbComp.StoredParms;
import VdbComp.WlComp;
import VdbComp.WlMenus;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;

public class CompFrame
extends JFrame
implements ActionListener {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private static boolean dirs_in_parm = false;
    private static WlComp wlcomp = null;
    public DataModel dm1;
    private DataModel2 dm2;
    JTable table1 = null;
    JTable table2 = null;
    public static volatile String search_value = "";
    private static JPanel top_panel = null;
    private static JTextField search = new JTextField("");
    private static JCheckBox hide1 = new JCheckBox("Hide 0-1%");
    private static JCheckBox hide2 = new JCheckBox("Hide 0-2%");
    private static JButton ok_button = new JButton("OK");
    private static JButton ext_button = new JButton("Exit");
    public static JScrollPane avg_scroll = null;
    private static JScrollPane dtl_scroll = null;
    private static JSplitPane split_pane = null;

    public CompFrame(WlComp wlComp) {
        wlcomp = wlComp;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StoredParms.storeParms();
                System.exit(0);
            }
        });
        this.setJMenuBar(new WlMenus(wlcomp));
        this.setCompareTitle();
        hide1.addActionListener(this);
        hide2.addActionListener(this);
        ext_button.addActionListener(this);
        ok_button.addActionListener(this);
        search.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                search_value = search.getText();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CompFrame.this.doCompare(true);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.setSize(StoredParms.last_width, StoredParms.last_height);
        this.setLocation(StoredParms.last_x, StoredParms.last_y);
        this.buildTopPanel();
    }

    public void buildTopPanel() {
        if (top_panel != null) {
            this.getContentPane().remove(top_panel);
        }
        JLabel jLabel = new JLabel("Search:");
        Dimension dimension = new Dimension(60, 20);
        search.setMinimumSize(dimension);
        search.setMaximumSize(dimension);
        search.setPreferredSize(dimension);
        int n = 0;
        top_panel = new JPanel();
        top_panel.setLayout(new GridBagLayout());
        top_panel.add((Component)hide1, new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)hide2, new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)jLabel, new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)search, new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)ok_button, new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)ext_button, new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        Delta[] deltaArray = Delta.getDeltas();
        for (int i = 0; i < deltaArray.length; ++i) {
            top_panel.add((Component)deltaArray[i], new GridBagConstraints(n++, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.getContentPane().add((Component)top_panel, "North");
    }

    public void doCompare(boolean bl) {
        this.clearTable();
        try {
            CompFrame.waitCursor(this);
            if (bl) {
                wlcomp.loadAllData();
            }
            double d = 0.0;
            if (hide1.isSelected()) {
                d = 1.0;
            }
            if (hide2.isSelected()) {
                d = 2.0;
            }
            this.dm1 = new DataModel();
            ArrayList<DataPair> arrayList = WlComp.createDataPairs(d);
            this.dm1.storePairs(arrayList);
            this.dm2 = new DataModel2();
            this.dm2.setDetail(new ArrayList<CompRunData>(0));
            this.table1 = new JTable(this.dm1);
            this.table2 = new JTable(this.dm2);
            this.dm1.setRenderers(this.table1);
            this.dm1.setColumnWidth(this.table1);
            this.dm2.setRenderers(this.table2);
            this.dm2.setColumnWidth(this.table2);
            MultiLineHeader multiLineHeader = new MultiLineHeader();
            Enumeration<TableColumn> enumeration = this.table1.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().setHeaderRenderer(multiLineHeader);
            }
            TableRowSorter<DataModel> tableRowSorter = new TableRowSorter<DataModel>(this.dm1);
            this.table1.setRowSorter(tableRowSorter);
            tableRowSorter.setStringConverter(new TableStringConverter(){

                @Override
                public String toString(TableModel tableModel, int n, int n2) {
                    Object object;
                    Object object2 = tableModel.getValueAt(n, n2);
                    if (object2 instanceof Double) {
                        double d = (Double)object2;
                        return String.format("%018.3f", 1.0E12 + d);
                    }
                    if (object2 instanceof String) {
                        object = (String)object2;
                        if (common.isDouble((String)(object = common.replace((String)object, ",", "")))) {
                            double d = Double.parseDouble((String)object);
                            return String.format("%018.3f", 1.0E12 + d);
                        }
                    }
                    if (object2 instanceof DeltaValue) {
                        object = (DeltaValue)object2;
                        String string = String.format("%018.3f", 1.0E12 + ((DeltaValue)object).value);
                        return string;
                    }
                    object = DataPair.expand(object2.toString());
                    return object;
                }
            });
            this.table2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() > 1) {
                        int n = CompFrame.this.table2.getSelectedRow();
                        CompRunData compRunData = CompFrame.this.dm2.getDetail(n);
                        CompFrame.startBrowser(compRunData.vdbench_dir, compRunData.reference);
                    } else if (mouseEvent.isMetaDown()) {
                        CompFrame.this.rightClickInTable(mouseEvent);
                    }
                }
            });
            this.table1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    CompFrame.this.rowSelected(CompFrame.this.table1, CompFrame.this.table1.convertRowIndexToModel(CompFrame.this.table1.getSelectedRow()));
                }
            });
            this.table1.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equalsIgnoreCase("up")) {
                        CompFrame.this.rowSelected(CompFrame.this.table1, CompFrame.this.table1.getSelectedRow());
                    } else if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equalsIgnoreCase("Down")) {
                        CompFrame.this.rowSelected(CompFrame.this.table1, CompFrame.this.table1.getSelectedRow());
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            if (split_pane != null) {
                this.getContentPane().remove(split_pane);
            }
            avg_scroll = new JScrollPane(this.table1);
            dtl_scroll = new JScrollPane(this.table2);
            split_pane = new JSplitPane(0, avg_scroll, dtl_scroll);
            this.getContentPane().add((Component)split_pane, "Center");
            this.setVisible(true);
            split_pane.setDividerLocation(0.8);
            this.setVisible(true);
        }
        catch (CompException compException) {
            common.ptod(compException);
            common.ptod("e.getMessage(): " + compException.getMessage());
            JOptionPane.showMessageDialog(this, "Error during Workload Compare: \n" + compException.getMessage(), "Processing Aborted", 0);
        }
        catch (Exception exception) {
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            String string = "\nStack Trace: ";
            for (int i = 0; stackTraceElementArray != null && i < stackTraceElementArray.length; ++i) {
                string = string + "\n at " + stackTraceElementArray[i].toString();
            }
            JOptionPane.showMessageDialog(this, "Error during Workload Compare: \n" + exception.toString() + "\t" + string, "Processing Aborted", 0);
        }
        CompFrame.waitCursor(this);
    }

    public void rowSelected(JTable jTable, int n) {
        ArrayList<CompRunData> arrayList = ((DataModel)jTable.getModel()).getDetail(n);
        this.dm2.setDetail(arrayList);
        this.dm2.setColumnWidth(this.table2);
        this.dm2.fireTableDataChanged();
    }

    public static void waitCursor(Component component) {
        if (component.getCursor().getType() != 3) {
            component.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            component.setCursor(Cursor.getDefaultCursor());
        }
    }

    private String getDirectory(String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select '" + string2 + "' Directory");
        jFileChooser.setFileSelectionMode(1);
        if (string != null && Fget.dir_exists(string)) {
            if (dirs_in_parm) {
                jFileChooser.setCurrentDirectory(new File(string));
            } else {
                jFileChooser.setCurrentDirectory(new File(string).getParentFile());
            }
        }
        if (jFileChooser.showOpenDialog(null) != 0) {
            return string;
        }
        string = jFileChooser.getSelectedFile().getAbsolutePath();
        if (avg_scroll != null) {
            this.getContentPane().remove(avg_scroll);
            this.update(this.getGraphics());
            this.setVisible(true);
        }
        return string;
    }

    public String getFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select file");
        jFileChooser.setFileSelectionMode(2);
        if (jFileChooser.showOpenDialog(null) != 0) {
            return null;
        }
        return jFileChooser.getSelectedFile().getAbsolutePath();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(hide1.getText())) {
            this.doCompare(false);
        } else if (string.equals(hide2.getText())) {
            this.doCompare(false);
        } else if (string.equals(ok_button.getText())) {
            this.doCompare(true);
        } else if (string.equals(ext_button.getText())) {
            StoredParms.storeParms();
            System.exit(0);
        }
        this.setCompareTitle();
    }

    private void setCompareTitle() {
        String string = "Vdbench Workload Comparator: ";
        for (int i = 1; i < WlComp.pos.size(); ++i) {
            string = string + WlComp.pos.get(i) + " ";
        }
        this.setTitle(string);
    }

    public void clearTable() {
        if (avg_scroll != null) {
            this.getContentPane().remove(avg_scroll);
            this.update(this.getGraphics());
            this.setVisible(true);
            avg_scroll = null;
        }
    }

    public boolean askOkCancel(String string) {
        int n = JOptionPane.showConfirmDialog(this, string, "Information message", 2);
        return n == 0;
    }

    private void rightClickInTable(MouseEvent mouseEvent) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.startsWith("Browse Vdbench output")) {
                    long l = Long.MAX_VALUE;
                    long l2 = 0L;
                    for (int i = 0; i < CompFrame.this.table2.getRowCount(); ++i) {
                        if (!CompFrame.this.table2.isRowSelected(i)) continue;
                        CompRunData compRunData = CompFrame.this.dm2.getDetail(i);
                        CompFrame.startBrowser(compRunData.vdbench_dir, compRunData.reference);
                    }
                }
            }
        };
        this.buildPopup(actionListener, mouseEvent);
    }

    private void buildPopup(ActionListener actionListener, MouseEvent mouseEvent) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        arrayList.add("Browse Vdbench output");
        String[] stringArray = arrayList.toArray(new String[0]);
        Pop_list pop_list = new Pop_list(stringArray, actionListener);
        pop_list.getPopup().show(this.table2, mouseEvent.getX(), mouseEvent.getY());
    }

    private static void startBrowser(String string, String string2) {
        if (common.onWindows()) {
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.addQuot("start ");
            oS_cmd.addQuot("firefox ");
            oS_cmd.add(string + "/summary.html#" + string2, new Object[0]);
            oS_cmd.execute();
        } else {
            String string3 = "/usr/bin/firefox";
            if (!Fget.file_exists(string3)) {
                string3 = "firefox";
            }
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.addQuot(string3);
            oS_cmd.add(string + "/summary.html", new Object[0]);
            oS_cmd.add("&", new Object[0]);
            oS_cmd.execute();
        }
    }
}

