/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Vdb.common;
import VdbComp.CompRunData;
import VdbComp.DataPair;
import VdbComp.DeltaValue;
import VdbComp.FractionCellRenderer;
import VdbComp.TableWidth;
import VdbComp.WlComp;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class DataModel
extends AbstractTableModel {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private ArrayList<String> column_names = null;
    private ArrayList<FractionCellRenderer> renderers = null;
    private ArrayList<DataPair> data_pairs;

    public void storePairs(ArrayList<DataPair> arrayList) {
        this.data_pairs = arrayList;
        Collections.sort(this.data_pairs);
        this.createcolumn_names();
    }

    public void createcolumn_names() {
        this.column_names = new ArrayList(32);
        this.renderers = new ArrayList(32);
        this.addColumn("Run", 0, 0, 2);
        this.addColumn("Old resp", 8, 3, 4);
        this.addColumn("New resp", 8, 3, 4);
        this.addColumn("Delta resp", 8, 3, 4);
        this.addColumn("Old iops", 8, 0, 4);
        this.addColumn("New iops", 8, 0, 4);
        this.addColumn("Delta iops", 8, 0, 4);
        this.addColumn("Old mbs", 8, 0, 4);
        this.addColumn("New mbs", 8, 0, 4);
        this.addColumn("Delta mbs", 8, 0, 4);
        this.addColumn("Old  max", 8, 2, 4);
        this.addColumn("New  max", 8, 2, 4);
        if (WlComp.getopt.check('v')) {
            this.addColumn("Old std", 8, 2, 4);
            this.addColumn("New std", 8, 2, 4);
            this.addColumn("Old rstd", 8, 3, 4);
            this.addColumn("New rstd", 8, 3, 4);
            this.addColumn("Regression", 8, 3, 4);
        }
        CompRunData compRunData = null;
        if (this.data_pairs.size() == 0) {
            return;
        }
        if (this.data_pairs.get((int)0).old_rd != null) {
            compRunData = this.data_pairs.get((int)0).old_rd;
        } else if (this.data_pairs.get((int)0).new_rd != null) {
            compRunData = this.data_pairs.get((int)0).new_rd;
        }
        if (compRunData != null && compRunData.flatfile_data.get("queue_depth") != null) {
            this.addColumn("Old qd", 8, 0, 4);
            this.addColumn("New qd", 8, 0, 4);
            this.addColumn("Delta qd", 8, 0, 4);
        }
        if (compRunData != null && compRunData.flatfile_data.get("read%") != null) {
            this.addColumn("Old rdpct", 6, 1, 4);
            this.addColumn("New rdpct", 6, 1, 4);
        }
    }

    private void addColumn(String string, int n, int n2, int n3) {
        this.column_names.add(string);
        this.renderers.add(new FractionCellRenderer(n, n2, n3));
    }

    public void setRenderers(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < this.column_names.size(); ++i) {
            tableColumnModel.getColumn(i).setCellRenderer(this.renderers.get(i));
        }
    }

    public void setColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < this.column_names.size(); ++i) {
            TableWidth.sizeColumn(i, jTable);
        }
    }

    public ArrayList<CompRunData> getDetail(int n) {
        DataPair dataPair = this.data_pairs.get(n);
        ArrayList<CompRunData> arrayList = new ArrayList<CompRunData>(8);
        if (dataPair.old_rd != null) {
            for (CompRunData compRunData : dataPair.old_rd.detail_list) {
                arrayList.add(compRunData);
            }
        }
        if (dataPair.new_rd != null) {
            for (CompRunData compRunData : dataPair.new_rd.detail_list) {
                arrayList.add(compRunData);
            }
        }
        return arrayList;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DataPair dataPair = this.data_pairs.get(n);
        CompRunData compRunData = null;
        String string = this.column_names.get(n2);
        try {
            if (string.equalsIgnoreCase("Run")) {
                return dataPair.rd_name;
            }
            if (dataPair.old_rd != null && dataPair.new_rd != null && string.equals("Regression")) {
                double d = dataPair.old_rd.rate_mean - dataPair.new_rd.rate_mean;
                d = d * 100.0 / dataPair.old_rd.rate_mean;
                return d;
            }
            compRunData = string.toLowerCase().startsWith("old") ? dataPair.old_rd : dataPair.new_rd;
            if (string.equalsIgnoreCase("Delta resp")) {
                return new DeltaValue(DataModel.getDelta(dataPair.old_rd, dataPair.new_rd, "Resp"));
            }
            if (string.equalsIgnoreCase("Delta iops")) {
                return new DeltaValue(DataModel.getDelta(dataPair.old_rd, dataPair.new_rd, "Rate"));
            }
            if (string.equalsIgnoreCase("Delta mbs")) {
                return new DeltaValue(DataModel.getDelta(dataPair.old_rd, dataPair.new_rd, "MB/sec"));
            }
            if (string.equalsIgnoreCase("Delta qd")) {
                return new DeltaValue(DataModel.getDelta(dataPair.old_rd, dataPair.new_rd, "queue_depth"));
            }
            if (compRunData == null) {
                return "n/a";
            }
            if (string.endsWith("resp")) {
                return compRunData.getValue("resp");
            }
            if (string.endsWith("iops")) {
                return String.format("%,.0f", compRunData.getValue("rate"));
            }
            if (string.endsWith("mbs")) {
                return compRunData.getValue("mb/sec");
            }
            if (string.endsWith("max")) {
                return compRunData.resp_max;
            }
            if (string.endsWith("qd")) {
                return compRunData.getValue("queue_depth");
            }
            if (string.endsWith("rdpct")) {
                return compRunData.getValue("read%");
            }
            if (string.endsWith("rstd")) {
                return compRunData.relative_std;
            }
            if (string.endsWith("std")) {
                return compRunData.rate_std;
            }
            return "DataModel n/a";
        }
        catch (Exception exception) {
            common.ptod("colname: " + string);
            common.ptod("dp.old_rd: " + dataPair.old_rd);
            common.ptod("dp.new_rd: " + dataPair.new_rd);
            common.failure(exception);
            return null;
        }
    }

    public static double getDelta(CompRunData compRunData, CompRunData compRunData2, String string) {
        if (compRunData == null || compRunData2 == null) {
            return 0.0;
        }
        if (compRunData.getValue(string) == null) {
            return 0.0;
        }
        double d = (Double)compRunData.getValue(string);
        double d2 = (Double)compRunData2.getValue(string);
        double d3 = d - d2;
        if (string.equalsIgnoreCase("Resp")) {
            return d3 * 100.0 / d;
        }
        return d3 * 100.0 / d * -1.0;
    }

    @Override
    public int getRowCount() {
        return this.data_pairs.size();
    }

    @Override
    public int getColumnCount() {
        return this.column_names.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.column_names.get(n);
    }

    public String getLabels(int n) {
        DataPair dataPair = this.data_pairs.get(n);
        if (dataPair.old_rd != null && dataPair.new_rd != null) {
            return dataPair.old_rd.label + " - " + dataPair.new_rd.label;
        }
        if (dataPair.old_rd != null) {
            return dataPair.old_rd.label;
        }
        return dataPair.new_rd.label;
    }
}

