/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Vdb.common;
import VdbComp.CompRunData;
import VdbComp.FractionCellRenderer;
import VdbComp.TableWidth;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class DataModel2
extends AbstractTableModel {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private ArrayList<String> column_names = new ArrayList(32);
    private ArrayList<FractionCellRenderer> renderers = new ArrayList(32);
    private ArrayList<CompRunData> detail;

    private void addColumn(String string, int n, int n2, int n3) {
        this.column_names.add(string);
        this.renderers.add(new FractionCellRenderer(n, n2, n3));
    }

    public void setDetail(ArrayList<CompRunData> arrayList) {
        this.detail = arrayList;
        this.column_names = new ArrayList(32);
        this.renderers = new ArrayList(32);
        CompRunData compRunData = null;
        if (this.detail.size() > 0) {
            compRunData = this.detail.get(0);
        }
        this.addColumn("Label (double click on row)", 0, 0, 2);
        this.addColumn("IOPS", 8, 3, 4);
        this.addColumn("Resp", 8, 3, 4);
        this.addColumn("Resp max", 8, 3, 4);
        this.addColumn("Resp stddev", 8, 3, 4);
        this.addColumn("MB/sec", 8, 3, 4);
    }

    public CompRunData getDetail(int n) {
        return this.detail.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CompRunData compRunData = this.detail.get(n);
        String string = this.column_names.get(n2);
        if (string.toLowerCase().startsWith("label")) {
            return compRunData.vdbench_dir;
        }
        if (string.equalsIgnoreCase("resp")) {
            return String.format("%,.3f", compRunData.getValue("resp"));
        }
        if (string.equalsIgnoreCase("iops")) {
            return String.format("%,.3f", compRunData.getValue("rate"));
        }
        if (string.equalsIgnoreCase("resp max")) {
            return String.format("%,.3f", compRunData.getValue("resp_max"));
        }
        if (string.equalsIgnoreCase("Resp stddev")) {
            return String.format("%,.3f", compRunData.getValue("resp_std"));
        }
        if (string.equalsIgnoreCase("MB/sec")) {
            return String.format("%,.0f", compRunData.getValue("MB/sec"));
        }
        if (string.equalsIgnoreCase("qdepth")) {
            return String.format("%,.0f", compRunData.getValue("queue_depth"));
        }
        return string;
    }

    public double getDelta(CompRunData compRunData, CompRunData compRunData2, String string) {
        if (compRunData.getValue(string) == null) {
            common.failure("can not find label: " + string);
        }
        double d = (Double)compRunData.getValue(string);
        double d2 = (Double)compRunData2.getValue(string);
        double d3 = d - d2;
        if (string.equalsIgnoreCase("Resp")) {
            return d3 * 100.0 / d;
        }
        return d3 * 100.0 / d * -1.0;
    }

    @Override
    public int getRowCount() {
        return this.detail.size();
    }

    @Override
    public int getColumnCount() {
        return this.column_names.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.column_names.get(n);
    }

    public void setColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableWidth.sizeColumn(i, jTable);
        }
    }

    public void setRenderers(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setCellRenderer(this.renderers.get(i));
        }
    }
}

