/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Utils.ClassPath;
import Utils.CommandOutput;
import Utils.Fget;
import Utils.Fput;
import Utils.Message;
import Utils.OS_cmd;
import Utils.common;
import Vdb.WindowsPDH;
import VdbComp.FractionCellRenderer;
import VdbComp.SdFormat;
import VdbComp.SdLeft;
import VdbComp.SdRight;
import VdbComp.TableWidth;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SdBuild
extends JFrame
implements ActionListener {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private static Vector luns_from_format = new Vector(64, 0);
    private static Vector lines_from_format = new Vector(64, 0);
    private static JPanel top_panel = null;
    private static JButton do_fdisk = new JButton("Run fdisk");
    private static JButton do_fdiskr = new JButton("Use fdisk output");
    private static JButton do_format = new JButton("Run format w/prtvtoc");
    private static JButton do_formatn = new JButton("Run format");
    private static JButton do_windows = new JButton("List disk drives");
    private static JButton do_read = new JButton("Use format output");
    private static JButton replace = new JButton("Replace parmfile");
    private static JButton go_left = new JButton("<<<<<");
    private static JButton go_right = new JButton(">>>>>");
    private static JButton do_exit = new JButton("Exit");
    private static JButton do_save = new JButton("Save");
    private static JLabel mask_lbl = new JLabel("Mask:");
    private static JComboBox mask = null;
    private static JLabel slice_lbl = new JLabel("     Slice:");
    private static JTextField slice = new JTextField("s6");
    private static JTextField status_bar = new JTextField();
    private static JPanel bottom = null;
    public static JScrollPane left_panel = null;
    public static JScrollPane right_panel = null;
    private JTable left_table;
    private JTable right_table;
    private SdLeft left_model;
    private SdRight right_model;

    public SdBuild() {
        this.setTitle("Vdbench SD parameter generation tool");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        mask = this.createComboBox();
        mask.setEditable(true);
        Dimension dimension = new Dimension(1024, 20);
        status_bar.setFont(new Font("Courier New", 0, 14));
        status_bar.setBackground(SystemColor.activeCaptionBorder);
        status_bar.setMinimumSize(dimension);
        status_bar.setPreferredSize(dimension);
        status_bar.setMaximumSize(dimension);
        dimension = new Dimension(250, 20);
        mask.setMinimumSize(dimension);
        mask.setPreferredSize(dimension);
        mask.setMaximumSize(dimension);
        do_fdisk.addActionListener(this);
        do_fdiskr.addActionListener(this);
        do_format.addActionListener(this);
        do_formatn.addActionListener(this);
        do_windows.addActionListener(this);
        do_read.addActionListener(this);
        replace.addActionListener(this);
        go_left.addActionListener(this);
        go_right.addActionListener(this);
        do_exit.addActionListener(this);
        do_save.addActionListener(this);
        mask.addActionListener(this);
        do_save.setEnabled(false);
        if (!common.onSolaris()) {
            do_format.setEnabled(false);
            do_formatn.setEnabled(false);
        }
        if (top_panel != null) {
            this.getContentPane().remove(top_panel);
        }
        int n = 0;
        int n2 = 4;
        top_panel = new JPanel();
        top_panel.setLayout(new GridBagLayout());
        top_panel.add((Component)do_exit, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)do_save, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (common.onLinux()) {
            top_panel.add((Component)do_fdisk, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            top_panel.add((Component)do_fdiskr, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        } else if (common.onSolaris()) {
            top_panel.add((Component)do_format, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            top_panel.add((Component)do_formatn, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            top_panel.add((Component)do_read, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        } else if (common.onWindows()) {
            top_panel.add((Component)do_windows, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            top_panel.add((Component)do_fdiskr, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        top_panel.add((Component)go_left, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)go_right, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)replace, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)mask_lbl, new GridBagConstraints(n2++, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        top_panel.add((Component)mask, new GridBagConstraints(n2++, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (common.onSolaris()) {
            top_panel.add((Component)slice_lbl, new GridBagConstraints(n2++, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            top_panel.add((Component)slice, new GridBagConstraints(n2++, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.getContentPane().add((Component)top_panel, "North");
        this.getContentPane().add((Component)status_bar, "South");
    }

    public static String getSlice() {
        return slice.getText();
    }

    public static String getMask() {
        return (String)mask.getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(do_exit.getText())) {
            System.exit(0);
        } else if (string.equals(go_left.getText())) {
            this.moveRightToLeft();
        } else if (string.equals(go_right.getText())) {
            this.moveLeftToRight();
        } else if (string.equals(do_format.getText())) {
            this.buildTables(true, true);
        } else if (string.equals(do_formatn.getText())) {
            this.buildTables(true, false);
        } else if (string.equals(do_read.getText())) {
            this.readFormatFromFile();
        } else if (string.equals(replace.getText())) {
            this.replaceParms();
        } else if (string.equals(do_save.getText())) {
            this.saveToFile();
        } else if (string.equals("comboBoxChanged") && this.left_table != null) {
            ((AbstractTableModel)this.left_table.getModel()).fireTableDataChanged();
        } else if (string.equals(do_windows.getText())) {
            this.getWindowsDiskList();
        } else if (string.equals(do_fdiskr.getText())) {
            this.readFdiskFromFile(null);
        } else if (string.equals(do_fdisk.getText())) {
            this.readFdiskFromFile(this.doFdisk());
        } else {
            common.failure("Invalid command: " + string);
        }
        this.setVisible(true);
    }

    private void readFormatFromFile() {
        String string = SdBuild.askForFile();
        if (string == null) {
            return;
        }
        String[] stringArray = Fget.readFileToArray(string);
        for (int i = 0; i < stringArray.length; ++i) {
            SdBuild.processFormatLine(stringArray[i], "stdout", false);
        }
        if (luns_from_format.size() == 0) {
            common.failure("No valid devices found.");
        }
        this.buildTables(false, false);
    }

    private void readFdiskFromFile(Vector vector) {
        String[] stringArray;
        if (vector == null) {
            String string = SdBuild.askForFile();
            if (string == null) {
                return;
            }
            stringArray = Fget.readFileToArray(string);
        } else {
            stringArray = vector.toArray(new String[0]);
        }
        luns_from_format.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], " ,:");
            if (stringTokenizer.countTokens() < 4 || !stringTokenizer.nextToken().equalsIgnoreCase("disk")) continue;
            SdFormat sdFormat = new SdFormat();
            sdFormat.lun = sdFormat.target = stringTokenizer.nextToken();
            sdFormat.slices = stringTokenizer.nextToken() + " " + stringTokenizer.nextToken();
            if (sdFormat.slices.startsWith("does")) continue;
            luns_from_format.add(sdFormat);
        }
        if (luns_from_format.size() == 0) {
            JOptionPane.showMessageDialog(null, "No valid devices found. Manually check output of 'fdisk -l'", "Try again", 0);
        }
        this.buildTables(false, false);
    }

    private void saveToFile() {
        String string = SdBuild.askForFile();
        if (string == null) {
            return;
        }
        Fput fput = new Fput(string);
        if (SdBuild.getMask().startsWith("sd=")) {
            fput.println("sd=default");
        }
        for (int i = 0; i < this.left_table.getRowCount(); ++i) {
            fput.println((String)this.left_table.getValueAt(i, 0));
        }
        fput.println("");
        fput.close();
    }

    private void moveRightToLeft() {
        int[] nArray = this.right_table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            SdFormat sdFormat = this.right_model.getRow(n);
            this.left_model.addRow(sdFormat);
        }
        this.right_model.removeRows(nArray);
        this.left_model.fireTableStructureChanged();
        this.right_model.fireTableStructureChanged();
        this.setColumnWidth(this.left_table);
        this.setColumnWidth(this.right_table);
    }

    private void moveLeftToRight() {
        int[] nArray = this.left_table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            SdFormat sdFormat = this.left_model.getRow(n);
            this.right_model.addRow(sdFormat);
        }
        this.left_model.removeRows(nArray);
        this.left_model.fireTableStructureChanged();
        this.right_model.fireTableStructureChanged();
        this.setColumnWidth(this.left_table);
        this.setColumnWidth(this.right_table);
    }

    public static Vector doFormat(boolean bl) {
        lines_from_format.removeAllElements();
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.setOutputMethod(new CommandOutput(){

            @Override
            public boolean newLine(String string, String string2, boolean bl) {
                lines_from_format.add(string2 + " " + string);
                return true;
            }
        });
        oS_cmd.addText("format << EOF");
        SdBuild.status("Running '" + oS_cmd.getCmd() + "'");
        oS_cmd.execute();
        SdBuild.status("'format' complete");
        luns_from_format.removeAllElements();
        for (int i = 0; i < lines_from_format.size(); ++i) {
            String string = (String)lines_from_format.elementAt(i);
            String string2 = string.substring(0, 6);
            String string3 = string.substring(6);
            SdBuild.processFormatLine(string3, string2, bl);
        }
        if (luns_from_format.size() == 0) {
            JOptionPane.showMessageDialog(null, "No valid devices found. Are you sure you have root access?", "Try again", 0);
        }
        return luns_from_format;
    }

    public Vector doFdisk() {
        lines_from_format.removeAllElements();
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.setOutputMethod(new CommandOutput(){

            @Override
            public boolean newLine(String string, String string2, boolean bl) {
                lines_from_format.add(string);
                return true;
            }
        });
        oS_cmd.addText("fdisk -l");
        SdBuild.status("Running '" + oS_cmd.getCmd() + "'");
        oS_cmd.execute();
        SdBuild.status("'fdisk' complete");
        return lines_from_format;
    }

    private static void processFormatLine(String string, String string2, boolean bl) {
        if (string2.equals("stdout") && string.indexOf("<") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = "n/a";
            stringTokenizer = new StringTokenizer(string4, "ct");
            if (stringTokenizer.countTokens() > 0) {
                string5 = stringTokenizer.nextToken();
            }
            SdFormat sdFormat = new SdFormat();
            sdFormat.disk_number = string3.substring(0, string3.indexOf("."));
            sdFormat.lun = string4;
            sdFormat.target = string5;
            luns_from_format.add(sdFormat);
            if (common.onSolaris() && bl) {
                SdBuild.getSizes(sdFormat);
            }
        }
    }

    private void buildTables(boolean bl, boolean bl2) {
        if (bl) {
            SdBuild.doFormat(bl2);
        }
        this.left_model = new SdLeft(new Vector(64, 0));
        this.right_model = new SdRight(luns_from_format);
        this.left_table = new JTable(this.left_model);
        this.right_table = new JTable(this.right_model);
        this.right_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    SdBuild.this.moveRightToLeft();
                }
            }
        });
        this.left_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    SdBuild.this.moveLeftToRight();
                }
            }
        });
        this.left_table.setFont(new Font("Courier New", 0, 12));
        this.right_table.setFont(new Font("Courier New", 0, 12));
        left_panel = new JScrollPane(this.left_table);
        right_panel = new JScrollPane(this.right_table);
        if (bottom != null) {
            this.getContentPane().remove(bottom);
        }
        bottom = new JPanel();
        bottom.setLayout(new GridBagLayout());
        bottom.add((Component)left_panel, new GridBagConstraints(0, 1, 1, 1, 0.8, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        bottom.add((Component)right_panel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setColumnWidth(this.left_table);
        this.setColumnWidth(this.right_table);
        left_panel.setPreferredSize(new Dimension(300, 9300));
        left_panel.setMinimumSize(new Dimension(300, 9900));
        right_panel.setPreferredSize(new Dimension(300, 9300));
        right_panel.setMinimumSize(new Dimension(300, 9900));
        this.getContentPane().add((Component)bottom, "Center");
        do_save.setEnabled(true);
    }

    private static String askForFile() {
        JFileChooser jFileChooser = new JFileChooser(new File(".").getAbsolutePath());
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(null) == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            return string;
        }
        return null;
    }

    private static void getSizes(SdFormat sdFormat) {
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText("prtvtoc -hs /dev/rdsk/" + sdFormat.lun + "s*");
        oS_cmd.setStdout();
        SdBuild.status("Running '" + oS_cmd.getCmd() + "'");
        oS_cmd.execute();
        String[] stringArray = oS_cmd.getStdout();
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i]);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            long l = Long.parseLong(stringTokenizer.nextToken());
            if (n >= 16) continue;
            sdFormat.sizes[n] = l * 512L;
        }
        SdBuild.status("");
    }

    public void setColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            DefaultTableCellRenderer defaultTableCellRenderer;
            TableWidth.sizeColumn(i, jTable);
            if (jTable != this.right_table) continue;
            if (common.onWindows()) {
                defaultTableCellRenderer = new DefaultTableCellRenderer();
                defaultTableCellRenderer.setHorizontalAlignment(2);
                tableColumnModel.getColumn(i).setCellRenderer(defaultTableCellRenderer);
                continue;
            }
            if (i <= 0) continue;
            defaultTableCellRenderer = new FractionCellRenderer(5, 1, 4);
            tableColumnModel.getColumn(i).setCellRenderer(defaultTableCellRenderer);
        }
    }

    public static void main(String[] stringArray) {
        SdBuild sdBuild = new SdBuild();
        sdBuild.setSize(1200, 600);
        Message.centerscreen(sdBuild);
        sdBuild.setVisible(true);
    }

    private static void status(String string) {
        status_bar.setText(string);
        status_bar.paintAll(status_bar.getGraphics());
    }

    private JComboBox createComboBox() {
        Object object;
        Vector<String> vector = new Vector<String>(8, 0);
        if (common.onLinux()) {
            vector.add("sd=sd#,lun=$,openflags=o_direct");
        } else if (common.onWindows()) {
            vector.add("sd=sd#,lun=\\\\.\\PhysicalDrive$");
        } else {
            vector.add("sd=sd#,lun=/dev/rdsk/$%");
        }
        vector.add("Edit file 'build_sds.txt' for more options");
        String string = ClassPath.classPath("build_sds.txt");
        if (Fget.file_exists(string)) {
            object = new Fget(string);
            String string2 = null;
            while ((string2 = ((Fget)object).get()) != null) {
                if ((string2 = string2.trim()).length() == 0 || string2.startsWith("*")) continue;
                vector.add(string2);
            }
            ((Fget)object).close();
        }
        object = new JComboBox(vector);
        return object;
    }

    private void replaceParms() {
        String string;
        String string2 = "This option will replace existing SD parameters. \nThis will only be valid if all SD names are sd1 through sd-n.";
        int n = JOptionPane.showConfirmDialog(null, string2, "Information message", 2);
        if (n != 0) {
            return;
        }
        String string3 = SdBuild.askForFile();
        if (string3 == null) {
            return;
        }
        String[] stringArray = Fget.readFileToArray(string3);
        Fput fput = new Fput(string3);
        int n2 = 0;
        for (n2 = 0; n2 < stringArray.length && (!(string = stringArray[n2]).startsWith("sd") || string.startsWith("sd=default")); ++n2) {
            fput.println(string);
        }
        while (n2 < stringArray.length && !(string = stringArray[n2]).startsWith("wd")) {
            ++n2;
        }
        for (int i = 0; i < this.left_model.getRowCount(); ++i) {
            fput.println((String)this.left_model.getValueAt(i, 0));
        }
        while (n2 < stringArray.length) {
            String string4 = stringArray[n2];
            fput.println(string4);
            ++n2;
        }
        fput.close();
    }

    public void getWindowsDiskList() {
        String[] stringArray = new String[]{"empty list"};
        try {
            String string = WindowsPDH.translateFieldNameOptional("PhysicalDisk");
            stringArray = WindowsPDH.getDisks(string);
            luns_from_format = new Vector(16, 0);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(" +");
                SdFormat sdFormat = new SdFormat();
                sdFormat.lun = sdFormat.target = stringArray2[0];
                sdFormat.slices = "PhysicalDisk" + sdFormat.lun;
                if (stringArray2.length > 1) {
                    sdFormat.slices = stringArray[i].substring(stringArray[i].indexOf(" "));
                }
                luns_from_format.add(sdFormat);
            }
            this.buildTables(false, false);
        }
        catch (Exception exception) {
            common.ptod("Not sure what happened here, but if I have a list of disks this is it:");
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                common.ptod("disks: " + stringArray[i]);
            }
            common.failure(exception);
        }
    }
}

