/*
 * Decompiled with CFR 0.152.
 */
package VdbComp;

import Utils.Fget;
import Utils.Fput;
import Utils.Getopt;
import Vdb.common;
import Vdb.ownmath;
import VdbComp.CompException;
import VdbComp.CompFrame;
import VdbComp.CompRunData;
import VdbComp.DataModel;
import VdbComp.DataPair;
import VdbComp.FlatFile;
import VdbComp.ParseData;
import VdbComp.StoredParms;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class WlComp {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private static boolean dirs_in_parm = false;
    public static CompFrame frame = null;
    public static Vector<CompRunData> old_rds = null;
    public static Vector<CompRunData> new_rds = null;
    public HashMap<String, String> all_keywords = null;
    public static Getopt getopt = null;
    public static Vector<String> pos = null;
    public static String mondir = "http://sbm-240a.us.oracle.com/shares/export/swat/swat_monitor_data";
    public static ArrayList<String> old_files = null;
    public static ArrayList<String> new_files = null;
    public static ArrayList<String> old_labels = null;
    public static ArrayList<String> new_labels = null;
    public static ArrayList<FlatFile> old_flats = null;
    public static ArrayList<FlatFile> new_flats = null;
    public static boolean add_parent = false;

    public static void main(String[] stringArray) {
        getopt = new Getopt(stringArray, "hvpo:d:i:", 999);
        getopt.print("Compare");
        if (!getopt.isOK()) {
            WlComp.usage("Parameter scan errors");
        }
        if (getopt.check('h')) {
            WlComp.usage("Help requested");
        }
        if (getopt.get_positionals().size() < 2) {
            WlComp.usage("Expecting a minimum of two positional parameters");
        }
        StoredParms.loadParms();
        add_parent = getopt.check('p');
        pos = getopt.get_positionals();
        if (pos.size() > 1) {
            dirs_in_parm = true;
        }
        WlComp wlComp = null;
        if (getopt.check('o')) {
            wlComp = new WlComp();
            wlComp.loadAllData();
            wlComp.batchExport(getopt.get_string());
            return;
        }
        wlComp = new WlComp();
        frame = new CompFrame(wlComp);
        frame.setSize(StoredParms.last_width, StoredParms.last_height);
        frame.setLocation(StoredParms.last_x, StoredParms.last_y);
        frame.setVisible(true);
        if (dirs_in_parm) {
            frame.doCompare(true);
        }
    }

    private static void usage(String string) {
        common.ptod("");
        common.ptod("");
        common.ptod(string);
        common.ptod("");
        common.ptod("Usage: ./vdbench compare dir_old dir_new [-o tab_sep_file]");
        common.ptod("");
        common.ptod("       ./vdbench compare old olddir1 olddir2 ..  new newdir1 newdir2 ... [-o tab_sep_file]");
        common.ptod("");
        common.ptod("");
        common.failure(string);
    }

    private static String getFlatFile(String string, String string2) {
        String string3 = String.format("%s/pdm/complete/%s/%05d/topframe.html", mondir, string, Integer.parseInt(string2));
        String string4 = WlComp.getOutput(string3);
        if (string4.endsWith("/summary.html")) {
            string4.replaceAll("/summary.html", "");
        }
        if (!string4.startsWith("http://")) {
            common.ptod("PDM %s/%s", string, string2);
            common.ptod("Output directory name does not start with 'http': " + string4);
            common.failure("Output directory either does not exist, or is improperly defined in the PDM translation table");
        }
        return string4;
    }

    private static String getOutput(String string) {
        String[] stringArray;
        for (String string2 : stringArray = Fget.readFileToArray(string)) {
            if (!string2.contains("Output:")) continue;
            String string3 = string2.substring(string2.indexOf("<a href=") + 9);
            if ((string3 = string3.substring(0, string3.indexOf("\""))).endsWith("/summary.html")) {
                string3 = string3.substring(0, string3.lastIndexOf("/"));
            }
            return string3;
        }
        if (stringArray == null) {
            common.failure("File '%s' does not contain valid output directory", string);
        }
        return null;
    }

    public void doCompare() {
        CompFrame.waitCursor(frame);
        this.loadAllData();
        CompFrame.waitCursor(frame);
    }

    public void loadAllData() {
        CompRunData compRunData;
        int n;
        int n2;
        old_files = new ArrayList(8);
        new_files = new ArrayList(8);
        old_labels = new ArrayList(8);
        new_labels = new ArrayList(8);
        old_flats = new ArrayList(8);
        new_flats = new ArrayList(8);
        if (!WlComp.usePdmInfo()) {
            if (pos.size() == 2) {
                dirs_in_parm = true;
                old_files.add(pos.get(1));
                new_files.add(pos.get(1));
                old_labels.add(pos.get(1));
                new_labels.add(pos.get(1));
            } else if (pos.size() == 3) {
                dirs_in_parm = true;
                old_files.add(pos.get(1));
                new_files.add(pos.get(2));
                old_labels.add(pos.get(1));
                new_labels.add(pos.get(2));
            } else if (pos.size() > 3) {
                dirs_in_parm = true;
                n2 = 0;
                boolean bl = false;
                for (n = 1; n < pos.size(); ++n) {
                    if (!pos.get(n).equals("old")) continue;
                    n2 = 1;
                    break;
                }
                if (n2 == 0) {
                    common.failure("'old' argument not found");
                }
                ++n;
                while (n < pos.size()) {
                    if (pos.get(n).equals("new")) {
                        bl = true;
                        break;
                    }
                    old_files.add(pos.get(n));
                    old_labels.add(pos.get(n));
                    ++n;
                }
                if (!bl) {
                    common.failure("'new' argument not found");
                }
                ++n;
                while (n < pos.size()) {
                    new_files.add(pos.get(n));
                    new_labels.add(pos.get(n));
                    ++n;
                }
            }
        }
        Collections.sort(old_files);
        Collections.sort(new_files);
        common.ptod("old_files: " + old_files.size());
        common.ptod("new_files: " + new_files.size());
        old_rds = new Vector(8, 0);
        for (n2 = 0; n2 < old_files.size(); ++n2) {
            FlatFile flatFile = new FlatFile(old_labels.get(n2), old_files.get(n2));
            if (!ParseData.parseFlatFile(flatFile, old_rds)) continue;
            old_flats.add(flatFile);
        }
        new_rds = new Vector(8, 0);
        for (n2 = 0; n2 < new_files.size(); ++n2) {
            FlatFile flatFile = new FlatFile(new_labels.get(n2), new_files.get(n2));
            if (!ParseData.parseFlatFile(flatFile, new_rds)) continue;
            new_flats.add(flatFile);
        }
        ParseData.parseSummary(old_flats);
        ParseData.parseSummary(new_flats);
        this.parseDescriptions();
        String string = CompFrame.search_value;
        String[] stringArray = string.trim().split(" +");
        if (string.length() > 0) {
            for (n = 0; n < old_rds.size(); ++n) {
                compRunData = old_rds.get(n);
                for (String string2 : stringArray) {
                    if (compRunData.rd_name.contains(string2)) continue;
                    old_rds.set(n, null);
                }
            }
            while (old_rds.remove(null)) {
            }
        }
        for (n = 0; n < new_rds.size(); ++n) {
            compRunData = new_rds.get(n);
            for (String string2 : stringArray) {
                if (compRunData.rd_name.contains(string2)) continue;
                new_rds.set(n, null);
            }
        }
        while (new_rds.remove(null)) {
        }
        if (old_rds.size() == 0) {
            throw new CompException("No valid runs found in flatfile.html");
        }
        this.insertAverages(old_rds);
        this.insertAverages(new_rds);
        Collections.sort(old_rds);
        Collections.sort(new_rds);
    }

    private static void countShortRdNames(Vector<CompRunData> vector) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>(32);
        for (CompRunData objectArray : vector) {
            if (objectArray.average) continue;
            Long l = (Long)hashMap.get(objectArray.rd_short);
            if (l == null) {
                l = new Long(0L);
            }
            l = l + 1L;
            hashMap.put(objectArray.rd_short, l);
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            common.ptod("Count: %-20s %3d", object, hashMap.get(object));
        }
    }

    private static boolean usePdmInfo() {
        String[] stringArray;
        String string;
        int n;
        String string2 = null;
        String string3 = null;
        if (pos.size() > 3) {
            String string4 = String.format("%s/pdm/complete/%s/index.html", mondir, pos.get(2));
            String[] stringArray2 = Fget.readFileToArray(string4);
            if (stringArray2 == null) {
                return false;
            }
        } else {
            return false;
        }
        string2 = string3 = pos.get(2);
        dirs_in_parm = true;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 1; n < pos.size(); ++n) {
            if (!pos.get(n).equals("old")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            common.failure("'old' argument not found");
        }
        n += 2;
        while (n < pos.size()) {
            if (pos.get(n).equals("new")) {
                bl2 = true;
                break;
            }
            string = WlComp.getFlatFile(string2, pos.get(n));
            old_files.add(string);
            old_labels.add(String.format("%s/%05d", string2, Integer.parseInt(pos.get(n))));
            ++n;
        }
        if (!bl2) {
            common.failure("'new' argument not found");
        }
        if ((stringArray = Fget.readFileToArray(string = String.format("%s/pdm/complete/%s/index.html", mondir, pos.get(n + 1)))) != null) {
            string3 = pos.get(n + 1);
            ++n;
        }
        ++n;
        while (n < pos.size()) {
            String string5 = WlComp.getFlatFile(string3, pos.get(n));
            new_files.add(string5);
            new_labels.add(String.format("%s/%05d", string3, Integer.parseInt(pos.get(n))));
            ++n;
        }
        return true;
    }

    private void insertAverages(Vector<CompRunData> vector) {
        HashMap<String, String> hashMap = new HashMap<String, String>(32);
        for (CompRunData object : vector) {
            hashMap.put(object.rd_name, object.rd_name);
        }
        for (String string : hashMap.keySet()) {
            CompRunData compRunData3;
            ArrayList<CompRunData> arrayList = new ArrayList<CompRunData>(8);
            CompRunData compRunData2 = null;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int n = 0;
            String string2 = "";
            for (CompRunData compRunData3 : vector) {
                if (!compRunData3.rd_name.equals(string)) continue;
                if (compRunData2 == null) {
                    compRunData2 = compRunData3;
                }
                ++n;
                double d6 = (Double)compRunData3.flatfile_data.get("rate");
                d += Double.valueOf(d6).doubleValue();
                d2 += ((Double)compRunData3.flatfile_data.get("resp")).doubleValue();
                d3 += ((Double)compRunData3.flatfile_data.get("mb/sec")).doubleValue();
                d4 += d6 * d6;
                string2 = string2 + compRunData3.label + " ";
                d5 = Math.max(d5, (Double)compRunData3.flatfile_data.get("resp_max"));
                arrayList.add(compRunData3);
            }
            if (compRunData2 == null) {
                common.failure("not expecting a null rd");
            }
            HashMap hashMap2 = (HashMap)compRunData2.flatfile_data.clone();
            compRunData3 = new CompRunData("", hashMap2, null);
            compRunData3.average = true;
            compRunData3.rd_name = string;
            compRunData3.flatfile_data.put("rate", d / (double)n);
            compRunData3.flatfile_data.put("resp", d2 / (double)n);
            compRunData3.flatfile_data.put("mb/sec", d3 / (double)n);
            compRunData3.rate_mean = d / (double)n;
            compRunData3.rate_std = ownmath.stddev(n, d4, d);
            compRunData3.relative_std = compRunData3.rate_std * 100.0 / compRunData3.rate_mean;
            compRunData3.resp_max = d5;
            compRunData3.detail_list = arrayList;
            vector.add(compRunData3);
        }
    }

    private void matchDirectories(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        String string;
        int n;
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        if (arrayList.size() + arrayList2.size() == 2) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(64);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(64);
        for (n = 0; n < arrayList.size(); ++n) {
            hashMap.put(new File(arrayList.get(n)).getParentFile().getName(), "x");
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            hashMap2.put(new File(arrayList2.get(n)).getParentFile().getName(), "x");
        }
        for (n = 0; n < arrayList.size(); ++n) {
            common.ptod("old_files: " + arrayList.get(n));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            common.ptod("new_files: " + arrayList2.get(n));
        }
        common.ptod("");
        for (n = 0; n < arrayList.size(); ++n) {
            string = new File(arrayList.get(n)).getParentFile().getName();
            if (hashMap2.get(string) != null) continue;
            common.ptod("No new matching directory found, removing: " + arrayList.get(n));
            arrayList.set(n, null);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            string = new File(arrayList2.get(n)).getParentFile().getName();
            if (hashMap.get(string) != null) continue;
            common.ptod("No old matching directory found, removing: " + arrayList2.get(n));
            arrayList2.set(n, null);
        }
        while (arrayList.remove(null)) {
        }
        while (arrayList2.remove(null)) {
        }
    }

    private HashMap parseDescriptions() {
        CompRunData compRunData;
        int n;
        this.all_keywords = new HashMap();
        for (n = 0; n < old_rds.size(); ++n) {
            compRunData = old_rds.elementAt(n);
            compRunData.parseForxxValues(this.all_keywords);
        }
        for (n = 0; n < new_rds.size(); ++n) {
            compRunData = new_rds.elementAt(n);
            compRunData.parseForxxValues(this.all_keywords);
        }
        return this.all_keywords;
    }

    public static ArrayList<DataPair> createDataPairs(double d) {
        DataPair dataPair;
        ArrayList<DataPair> arrayList = new ArrayList<DataPair>(1024);
        common.ptod("old_rds.size(): " + old_rds.size());
        common.ptod("new_rds.size(): " + new_rds.size());
        HashMap<String, DataPair> hashMap = new HashMap<String, DataPair>(512);
        for (CompRunData object : old_rds) {
            if (!object.average) continue;
            dataPair = (DataPair)hashMap.get(object.rd_name + object.label);
            dataPair = new DataPair();
            dataPair.old_rd = object;
            dataPair.rd_name = object.rd_name;
            hashMap.put(object.rd_name + object.label, dataPair);
        }
        for (CompRunData compRunData : new_rds) {
            if (!compRunData.average) continue;
            dataPair = (DataPair)hashMap.get(compRunData.rd_name + compRunData.label);
            if (dataPair == null) {
                dataPair = new DataPair();
                dataPair.new_rd = compRunData;
                dataPair.rd_name = compRunData.rd_name;
                hashMap.put(compRunData.rd_name + compRunData.label, dataPair);
                continue;
            }
            dataPair.new_rd = compRunData;
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            DataPair dataPair2 = (DataPair)hashMap.get(object);
            arrayList.add(dataPair2);
        }
        if (d != 0.0) {
            for (DataPair dataPair3 : arrayList) {
                if (dataPair3 == null) continue;
                double d2 = DataModel.getDelta(dataPair3.old_rd, dataPair3.new_rd, "resp");
                double d3 = DataModel.getDelta(dataPair3.old_rd, dataPair3.new_rd, "rate");
                if (!(Math.abs(d2) < d) || !(Math.abs(d3) < d)) continue;
                arrayList.set(arrayList.indexOf(dataPair3), null);
            }
        }
        while (arrayList.remove(null)) {
        }
        common.ptod("Amount of data pairs: %d", arrayList.size());
        return arrayList;
    }

    public void batchExport(String string) {
        ArrayList<DataPair> arrayList = WlComp.createDataPairs(0.0);
        Collections.sort(arrayList);
        Fput fput = new Fput(string);
        String string2 = fput.println("rd\told_resp\tnew_resp\tdelta_resp\told_rate\tnew_rate\tdelta_rate\told_mb\tnew_mb\tdelta_mb\told_max\tnew_max\told_std\tnew_std\told_rstd\tnew_rstd\tregress\t");
        for (DataPair dataPair : arrayList) {
            CompRunData compRunData = dataPair.old_rd;
            CompRunData compRunData2 = dataPair.new_rd;
            String string3 = dataPair.rd_name;
            if (compRunData == null || compRunData2 == null) {
                common.ptod("Missing '%s' data for %s; skipped", compRunData == null ? "old" : "new", dataPair.rd_name);
                continue;
            }
            string3 = string3 + "\t" + String.format("%.3f", compRunData.flatfile_data.get("resp"));
            string3 = string3 + "\t" + String.format("%.3f", compRunData2.flatfile_data.get("resp"));
            string3 = string3 + "\t" + String.format("%s", WlComp.getDelta(compRunData, compRunData2, "resp"));
            string3 = string3 + "\t" + String.format("%.3f", compRunData.flatfile_data.get("rate"));
            string3 = string3 + "\t" + String.format("%.3f", compRunData2.flatfile_data.get("rate"));
            string3 = string3 + "\t" + String.format("%s", WlComp.getDelta(compRunData, compRunData2, "rate"));
            string3 = string3 + "\t" + String.format("%.3f", compRunData.flatfile_data.get("mb/sec"));
            string3 = string3 + "\t" + String.format("%.3f", compRunData2.flatfile_data.get("mb/sec"));
            string3 = string3 + "\t" + String.format("%s", WlComp.getDelta(compRunData, compRunData2, "mb/sec"));
            string3 = string3 + "\t" + String.format("%s", compRunData.resp_max);
            string3 = string3 + "\t" + String.format("%s", compRunData2.resp_max);
            string3 = string3 + "\t" + String.format("%.3f", compRunData.rate_std);
            string3 = string3 + "\t" + String.format("%.3f", compRunData2.rate_std);
            string3 = string3 + "\t" + String.format("%.3f", compRunData.relative_std);
            string3 = string3 + "\t" + String.format("%.3f", compRunData2.relative_std);
            if (compRunData != null && compRunData2 != null) {
                double d = compRunData.rate_mean - compRunData2.rate_mean;
                d = d * 100.0 / compRunData.rate_mean;
                string3 = string3 + "\t" + String.format("%.3f", d);
            } else {
                string3 = string3 + "\t";
            }
            fput.println(string3);
        }
        fput.close();
    }

    private static String getDelta(CompRunData compRunData, CompRunData compRunData2, String string) {
        if (compRunData.flatfile_data.get(string) == null) {
            common.failure("can not find label: " + string);
        }
        double d = (Double)compRunData.flatfile_data.get(string);
        double d2 = (Double)compRunData2.flatfile_data.get(string);
        double d3 = d - d2;
        if (string.equals("resp")) {
            return String.format("%.1f%%", d3 * 100.0 / d);
        }
        return String.format("%.1f%%", d3 * 100.0 / d * -1.0);
    }
}

